<?php
$this->load->view ( $left );
$this->load->view ( $header );
?>
<div class="row wrapper border-bottom white-bg page-heading">

    <?php if($this->session->flashdata('message')){?>
        <div class="col-sm-12">
            <div class="alert alert-success">
              <strong>Success!</strong> <?php echo $this->session->flashdata('message');?>
            </div>
        </div>
    <?php } ?>

    <div class="col-sm-4">
        <h2>Product List</h2>
    </div>
    <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php echo site_url("all_products/newproduct");?>" class="btn btn-primary addNewUser">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">New Product</span>
            </a>
            
            <p><?php echo $links; ?></p>
        </div>
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <table class="table" id="myTable">
        	<thead>
        		<tr>
        			<th>Name</th>
                    <th>SKU</th>
                    <th>vendor</th>
                    <th>color</th>
                    <th>Made In</th>
                    <th>Edit/Delete</th>
        		</tr>
        	</thead>
            <tbody>
                <?php 
//                echo "<pre>";
//                print_r($invoice_list);
//                die(); 
                if (count($invoice_list) > 0) {
                    foreach ($invoice_list as $key_invoice => $value_invoice) {                        
                        ?>
                        <tr class="invoice_edit1" data-invoice_id="<?php echo !empty($value_invoice->id) ? $value_invoice->id : '';?>">
                           <td><?php echo !empty($value_invoice->name) ? $value_invoice->name : '';?></td> 
                           <td><?php echo substr(!empty($value_invoice->photo_id) ? $value_invoice->photo_id : '',0,100);?></td>
                           <td><?php echo !empty($value_invoice->vendor) ? $value_invoice->vendor : '';?></td>
                           <td><?php echo !empty($value_invoice->color) ? $value_invoice->color : '';?></td>
                           <td><?php echo !empty($value_invoice->made_in) ? $value_invoice->made_in : '';?></td>
                           <td>
                               <a href="<?php echo site_url("all_products/edit/".$value_invoice->id);?>"><button class="btn btn-info btn-xs"><i class="fa fa-edit"></i></button></a>
                               &nbsp;<a href="<?php echo site_url("all_products/copy/".$value_invoice->id);?>"><button class="btn btn-primary btn-xs"><i class="fa fa-copy"></i></button></a>
                               &nbsp;<a href="<?php echo site_url("all_products/delete/".$value_invoice->id);?>"><button class="btn btn-danger btn-xs"><i class="fa fa-trash"></i></button></a>
                           </td>                                              
                        </tr>
                <?php }
                }?>
            </tbody>
        </table>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript">
	$(document).ready(function(){
       // $('#myTable').DataTable();

        $('.invoice_edit').on('click',function(){
            var invoice = $(this).data('invoice_id');
            //window.location.href = '<?php //echo site_url("invoice/invoice_print/'+invoice+'");?>';
            window.open('<?php echo site_url("invoice/invoice_print/'+invoice+'");?>','_blank');
        });
	});
</script>

<script type="text/javascript" language="javascript" src="//code.jquery.com/jquery-1.12.4.js"></script>
    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script> 	
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script> 
    <script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

<script type="text/javascript">
	var jq = jQuery.noConflict();

	jq(document).ready(function() {
	jq('#myTable').DataTable({
          "lengthChange": false,
          "bPaginate": false
        });
	} );

</script>	