<?php
$this->load->view($left);
$this->load->view($header);
?>
<div class="row wrapper border-bottom white-bg page-heading">

    <?php if ($this->session->flashdata('message')) { ?>
        <div class="col-sm-12">
            <div class="alert alert-success">
                <strong>Success!</strong> <?php echo $this->session->flashdata('message'); ?>
            </div>
        </div>
    <?php } ?>

    <div class="col-sm-4">
        <h2>Product List</h2>
    </div>
    <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php echo site_url("all_products/newproduct"); ?>" class="btn btn-primary addNewUser">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">New Product</span>
            </a>
            <a href="<?php echo site_url("all_products/newConsumerProduct"); ?>" class="btn btn-primary addNewUser">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">New Consumer Product</span>
            </a>
        </div>
        
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <div class="col-lg-12">            
            <input type="hidden" name="id" id="id" class="form-control" value="<?= @$shape_row->id ?>">
            <div class="ibox float-e-margins">
                <div class="ibox-content">
                    <div class="form-group">
                        <label class="col-sm-1 control-label">Vendor</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="vendor" id="vendor" required>
                                <option value="">Select Vendor</option>
                                <?php
                                if (count($vendor_list) > 0) {
                                    foreach ($vendor_list as $key => $value) {
                                        ?>
                                        <option value="<?php echo $value->id; ?>" ><?php echo $value->vendor_name; ?></option>
                                        <?php
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-sm-2">
                            <select class="form-control" name="status" id="status">
                                <option value="">Select Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="all">All</option>
                               
                            </select>
                        </div>
                        <div class="col-sm-2">
                            <select class="form-control" name="is_commercial" id="is_commercial">
                                <option value="">Is Commercial</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                        <div class="col-sm-2">
                            <button class="btn btn-info" type="button" id="serch_btn"><i class="fa fa-search"></i><span class="m-l-xs">Search</span></button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="ibox float-e-margins">
                <div class="ibox-content">
                    <div class="form-group">
                        <label class="col-sm-1 control-label">Photo Id</label>
                        <div class="col-sm-2">
                            <input type="text" name="photo_id" id="photo_id" class="form-control" placeholder="Photo Id" value="">
                        </div>   
                        <div class="col-sm-2">
                            <button class="btn btn-primary form-control" id="serch_btn3">Search</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
    </div> 
</div> 
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <table class="table" id="myTable">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>SKU</th>
                    <th>vendor</th>
                    <th>color</th>
                    <th>Delivered</th>
                    <th>Made In</th>
                    <th>Edit/Delete</th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript">
    $(document).ready(function () {
        // $('#myTable').DataTable();

        $('.invoice_edit').on('click', function () {
            var invoice = $(this).data('invoice_id');
            //window.location.href = '<?php //echo site_url("invoice/invoice_print/'+invoice+'"); ?>';
            window.open('<?php echo site_url("invoice/invoice_print/'+invoice+'"); ?>', '_blank');
        });
    });
</script>

<script type="text/javascript" language="javascript" src="//code.jquery.com/jquery-1.12.4.js"></script>
<script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script src="//cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script> 	
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script> 
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

<script type="text/javascript">
    var jq = jQuery.noConflict();

    jq(document).ready(function () {
        jq(document).on('click', '#serch_btn', function () {
            var vendor = jq('#vendor').val();
            var status = jq('#status').val();
            var is_commercial = jq('#is_commercial').val();
            jq('#myTable').DataTable({
                "ajax": {
                    url: "<?php echo base_url(); ?>all_products/product_data/" + vendor+'/'+status+'/'+is_commercial,
                    type: 'GET'
                },
                "bDestroy": true,
            });

        });
        
        jq(document).on('click', '#serch_btn3', function () {
             var photo_id = jq('#photo_id').val();
             jq('#myTable').DataTable({
                "ajax": {
                    url: "<?php echo base_url(); ?>all_products/product_data_by_photo_id/" +photo_id,
                    type: 'GET'
                },
                "bDestroy": true,
            });

        });

    });

</script>	