<?php
$this->load->view ( $left );
$this->load->view ( $header );
?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-4">
        <h2>Expence List</h2>
    </div>
    <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php echo site_url("expence/newExpence");?>" class="btn btn-primary">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">Add Expence</span>
            </a>
        </div>
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <table class="table" id="myTable">
        	<thead>
        		<tr>
        			<th>Customer</th>
        			<th>Date</th>
                    <th>Bank Name</th>
                    <th>Expence Type</th>
                    <th>Amount</th>
                    <th>GST%</th>
                    <th>Total</th>
        			<th>Action</th>
        		</tr>
        	</thead>
            <tbody>
                <?php if (count($list_expence) > 0) {
                    foreach ($list_expence as $key_expence => $value_expence) {?>
                        <tr>
                           <td><?php echo !empty($value_expence->vendor_customer_name) ? $value_expence->vendor_customer_name : '';?></td>
                           <td><?php echo !empty($value_expence->expence_date) ? $value_expence->expence_date : '';?></td>
                           <td><?php echo !empty($value_expence->bank_name) ? $value_expence->bank_name  : '';?></td>
                           <td><?php echo !empty($value_expence->expence_type ) ? $value_expence->expence_type : '';?></td>
                           <td><?php echo !empty($value_expence->amount ) ? number_format((float)($value_expence->amount), 2, '.', '') : '0.00';?></td>
                           <td><?php echo !empty($value_expence->gst_rate ) ? $value_expence->gst_rate : '';?></td>
                           <td><?php echo !empty($value_expence->amount ) ? number_format((float)($value_expence->tax_amount+$value_expence->amount), 2, '.', '') : '0.00';?></td>
                           <td><a href="<?php echo site_url('expence/newExpence/'.$value_expence->expence_id);?>"><button class="btn btn-info btn-xs"><i class="fa fa-edit"></i></button></a></td>
                        </tr>
                <?php }
                }?>
            </tbody>
        </table>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript" language="javascript" src="//code.jquery.com/jquery-1.12.4.js"></script>
    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script> 	
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script> 
    <script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

<script type="text/javascript">
	var jq = jQuery.noConflict();

	jq(document).ready(function() {
	jq('#myTable').DataTable( {
			dom: 'Bfrtip',
			buttons: [
				'copy', 'csv', 'excel', 'pdf', 'print'
			]
		} );
	} );

</script>	