<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Color_model extends CI_Model {

    public function Add($table, $data) {
        $this->db->insert($table, $data);
        if ($this->db->affected_rows() > 0)
            return $this->db->insert_id();
        return false;
    }

    public function Edit($table, $data, $field = '', $id = '') {
        if (!empty($field)):
            $this->db->where($field, $id);
//        echo $this->db->last_query();
//        exit;
        endif;

        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0)
            return true;
        return false;
    }

    public function DelWhere($table, $where) {
        $this->db->where($where);
        $this->db->delete($table);
        if ($this->db->affected_rows() > 0)
            return true;
        return false;
    }

    public function AllRecordWithWhere($table, $where) {
        $query = $this->db->get_where($table, $where);
//                echo $this->db->last_query();
//        exit;
        return ($query->num_rows() > 0) ? $query : false;
    }

    public function AllRecord($table, $start = 0, $end = 0) {
        if ($start == $end || $start < 0 || $end < 0) {
            $query = $this->db->get($table);
        } else {
            $query = $this->db->get($table, $start, $end);
        }
        return ($query->num_rows() > 0) ? $query : false;
    }

    public function GetARecordWithWhereRowDESC($table, $where) {
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get_where($table, $where);
//        echo $this->db->last_query();
//        exit;
        return $query->row();
    }

}
