<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Purchase_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
        $this->db = $this->load->database('default', TRUE);
        $CI =& get_instance();
        $CI->db =& $this->db;
    }

    public function insert_data($table_name,$invoice_basic){
        $this->db->insert($table_name,$invoice_basic);
        return $this->db->insert_id();
    }

    public function insert_data_batch($table_name,$invoice_basic){
    	$this->db->insert_batch($table_name,$invoice_basic);
    }

    public function purchase_list(){
        return $this->db->select('purchase_bill.*,sum(bill_payment.payment) payment,contact_user.name')
                        ->from('purchase_bill as purchase_bill')
                        ->join('bill_payment as bill_payment','purchase_bill.purchase_bill_id = bill_payment.purchase_bill_id','left')
                        ->join('contact_user as contact_user','purchase_bill.vendor_id = contact_user.id')
                        ->where('purchase_bill.status','1')
                        ->group_by('purchase_bill.bill_no')
                        ->order_by('purchase_bill.due_date','DESC')
                        ->get()
                        ->result();
    }

    public function debit_note_list(){
    	return $this->db->select('devid_note.*,contact_user.name')
    					->from('devid_note as devid_note')
    					->join('contact_user as contact_user','devid_note.vendor_id = contact_user.id')
    					->where('devid_note.status','1')
    					->group_by('devid_note.devid_note_no')
    					->get()
    					->result();
    }

    public function get_from_table($table_name,$select,$where){
        return $this->db->select($select)
                        ->from($table_name)
                        ->where($where)
                        ->get()
                        ->result();
    }

    public function delete_data($table,$where){
        $this->db->where($where);
        $this->db->delete($table);
    }

    public function update_data($tablename,$update_data,$where){
        $this->db->where($where);
        $this->db->update($tablename,$update_data);
    }

    function bill_payment_list(){
        return $this->db->select('payment_made.*,GROUP_CONCAT(purchase_bill.bill_no) bill_no,SUM(bill_payment.payment) bill_paid_amount,contact_user.name customer_name')
                        ->from('payment_made as payment_made')
                        ->join('bill_payment as bill_payment','payment_made.payment_made_id = bill_payment.payment_made_id','left')
                        ->join('purchase_bill as purchase_bill','bill_payment.purchase_bill_id = purchase_bill.purchase_bill_id','left')
                        ->join('contact_user as contact_user','payment_made.vendor_id = contact_user.id','left')
                        ->group_by('payment_made.payment_made_id')
                        ->get()
                        ->result();
    }

    function get_bills_for_user($user_id){
        return $this->db->select('*')
                        ->from('purchase_bill')
                        ->where('vendor_id',$user_id)
                        ->order_by('due_date','asc')
                        ->get()
                        ->result();
    }

    function paid_bills($user_id){
        return $this->db->select('gst_bill_payment.purchase_bill_id bill_id')
                        ->from('gst_bill_payment')
                        ->join('gst_purchase_bill','gst_bill_payment.purchase_bill_id = gst_purchase_bill.purchase_bill_id','left')
                        ->where('gst_purchase_bill.vendor_id',$user_id)
                        ->get()
                        ->result();
    }

    function payment_bill_details($payment_id){
        return $this->db->select('bill_payment.*,purchase_bill.*')
                        ->from('bill_payment bill_payment')
                        ->join('purchase_bill purchase_bill','bill_payment.purchase_bill_id = purchase_bill.purchase_bill_id')
                        ->where('bill_payment.payment_made_id',$payment_id)
                        ->get()
                        ->result();
    }

}?>