<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
        $this->db = $this->load->database('default', TRUE);
        $CI =& get_instance();
        $CI->db =& $this->db;
    }

    public function insert_data($table_name,$invoice_basic){
        $this->db->insert($table_name,$invoice_basic);
        return $this->db->insert_id();
    }

    public function insert_data_batch($table_name,$invoice_basic){
    	$this->db->insert_batch($table_name,$invoice_basic);
    }

    public function product_list($page){
        $limit = 50;
        $start = $page*50 ;

    	return $this->db->select('*')
    					->from('rugs_tmp')
                        ->order_by('id','DESC')
                        ->limit($limit, $start)
    					->get()
    					->result();
    }


    public function get_vendor(){
        return $this->db->select('*')
                        ->from('vendors')
                        ->get()
                        ->result();
    }


    public function category_list(){
        return $this->db->select('*')
                        ->from('categories')
                        ->get()
                        ->result();
    }


    public function credit_note_list(){
        return $this->db->select('credit_note.*,contact_user.name')
                        ->from('credit_note as credit_note')
                        ->join('contact_user as contact_user','credit_note.customer_id = contact_user.id','left')
                        ->group_by('credit_note.credit_note_no')
                        ->get()
                        ->result();
    }

    public function get_from_table($table_name,$select,$where){
        return $this->db->select($select)
                        ->from($table_name)
                        ->where($where)
                        ->get()
                        ->result();
    }

    public function delete_data($table,$where){
        $this->db->where($where);
        $this->db->delete($table);
    }

    public function update_data($tablename,$update_data,$where){
        $this->db->where($where);
        $this->db->update($tablename,$update_data);
    }

    function get_invoice_for_user($user_id){
        return $this->db->select('*')
                        ->from('gst_sale_invoice')
                        ->where('customer_id',$user_id)
                        ->order_by('due_date','asc')
                        ->get()
                        ->result();
    }

    function paid_invoices($user_id){
        return $this->db->select('gst_invoice_payment.sale_invoice_id invoice_id')
                        ->from('gst_invoice_payment')
                        ->join('gst_sale_invoice','gst_invoice_payment.sale_invoice_id = gst_sale_invoice.sale_invoice_id','left')
                        ->where('gst_sale_invoice.customer_id',$user_id)
                        ->get()
                        ->result();
    }

    function customer_recive_payment(){
        return $this->db->select('payment_received.*,GROUP_CONCAT(sale_invoice.invoice_no) invoice_no,SUM(invoice_payment.amount) invoice_paid_amount,contact_user.name customer_name')
                        ->from('payment_received as payment_received')
                        ->join('invoice_payment as invoice_payment','payment_received.payment_received_id = invoice_payment.payment_received_id','left')
                        ->join('sale_invoice as sale_invoice','invoice_payment.sale_invoice_id = sale_invoice.sale_invoice_id','left')
                        ->join('contact_user as contact_user','payment_received.customer_id = contact_user.id','left')
                        ->group_by('payment_received.payment_received_id')
                        ->get()
                        ->result();
    }
    
    
    function received_invoce_details($recive_id){
        return $this->db->select('invoice_payment.*,sale_invoice.*')
                        ->from('invoice_payment invoice_payment')
                        ->join('sale_invoice sale_invoice','invoice_payment.sale_invoice_id = sale_invoice.sale_invoice_id')
                        ->where('invoice_payment.payment_received_id',$recive_id)
                        ->get()
                        ->result();
    }
    
    

}?>