<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Item_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
        $this->db = $this->load->database('default', TRUE);
        $CI =& get_instance();
        $CI->db =& $this->db;
    }

    public function insert_data($table,$data){
    	$this->db->insert($table,$data);
        return $this->db->insert_id();
    }

    public function get_items(){
    	return $this->db->select('*')
    					->from('items')
    					->where('status','1')
    					->group_by('item_id')
    					->get()
    					->result();
    }

    public function get_item_details($id_item){
    	return $this->db->select('*')
    					->from('items')
    					->where('item_id',$id_item)
    					->get()
    					->row();
    }
    
    public function items_name_check($item_name){
    	return $this->db->select('*')
    					->from('items')
    					->where('item_name',$item_name)
    					->get()
    					->num_rows();
    }

    public function update_data($tablename,$update_data,$where){
        $this->db->where($where);
        $this->db->update($tablename,$update_data);
    }

    public function get_stock($item){
        return $this->db->select('SUM(qty_purchase) purchase,SUM(qty_sale) sale,(SUM(qty_purchase) - SUM(qty_sale)) stock')
                        ->from('item_stock')
                        ->where('item_id',$item)
                        ->get()
                        ->row();
    }

    public function item_list(){
        return $this->db->select('*')
                        ->from('items')
                        ->get()
                        ->result();
    }
}?>