<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Expence_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
        $this->db = $this->load->database('default', TRUE);
        $CI =& get_instance();
        $CI->db =& $this->db;
    }

    public function get_from_table($table_name,$select,$where){
        return $this->db->select($select)
                        ->from($table_name)
                        ->where($where)
                        ->get()
                        ->result();
    }

    public function get_expence_items(){
		return $this->db->select('*')
						->from('expence_account')
						// ->where()
						->get()
						->result();
	}

	public function insert_expence_type($expence_data){
    	$this->db->insert('expence_account',$expence_data);
    }

    public function update_expence_type($expence_data,$expence_id){
    	$this->db->where('expence_acc_id',$expence_id);
    	$this->db->update('expence_account',$expence_data);
    }

    public function insert_expence($expence_data){
    	$this->db->insert('expences',$expence_data);
    }

    public function update_expence($expence_data,$expence_id){
    	$this->db->where('expence_id',$expence_id);
    	$this->db->update('expences',$expence_data);
    }

    public function get_expence_details($expence_id){
    	return $this->db->select('*')
    					->from('expence_account')
    					->where('expence_acc_id',$expence_id)
    					->get()
    					->row();
    }

    public function list_expences(){
    	return $this->db->select('expences.*,expence_account.expence_acc_name expence_type,bank_accounts.account_name bank_name')
    					->from('expences expences')
    					->join('expence_account expence_account','expences.expence_acc_id = expence_account.expence_acc_id','left')
    					->join('bank_accounts bank_accounts','expences.paid_through_acc = bank_accounts.account_id','left')
    					// ->where('expence_acc_id',$expence_id)
    					->get()
    					->result();
    }

}