<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Design_model extends CI_Model {

    public function Add($table, $data) {
        $this->db->insert($table, $data);
        if ($this->db->affected_rows() > 0)
            return $this->db->insert_id();
        return false;
    } 

    public function Edit($table, $data, $field = '', $id = '') {
        if (!empty($field)):
            $this->db->where($field, $id);
//        echo $this->db->last_query();
//        exit;
        endif;

        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0)
            return true;
        return false;
    }

    public function DelWhere($table, $where) {
        $this->db->where($where);
        $this->db->delete($table);
        if ($this->db->affected_rows() > 0)
            return true;
        return false;
    }

    public function AllRecordWithWhere($table, $where) {
        $query = $this->db->get_where($table, $where);
//                echo $this->db->last_query();
//        exit;
        return ($query->num_rows() > 0) ? $query : false;
    }

    public function AllRecord($table, $select = array(), $start = 0, $end = 0) {
        if(count($select) > 0){
            $this->db->select(implode(',', $select));
        }

        if ($start == $end || $start < 0 || $end < 0) {
            $query = $this->db->get($table);
        } else {
            $query = $this->db->get($table, $start, $end);
        }
        return ($query->num_rows() > 0) ? $query : false;
    }

    public function GetARecordWithWhereRowDESC($table, $where) {
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get_where($table, $where);
//        echo $this->db->last_query();
//        exit;
        return $query->row();
    }
public function getAllImportData(){
    $this->db->select("ip.*,ve.vendor_name");
    $this->db->from("import_products ip");
    $this->db->join("vendors ve","ve.id=ip.vendor","left");
    return $this->db->get();
    
}
public function getAllProductData($row,$page,$dat,$draw,$status){
    $this->db->select("ip.*,sum(case when ct.qty>0 then ct.qty else 0 end)delivered,co.color");
        $this->db->where("ip._vendor",$dat);

        if($status!='all'){
            if($status=='active'){
        $this->db->where("ip.new_arrival!=",2);
            }
            if($status=='inactive'){
        $this->db->where("ip.new_arrival",2);
            }
        }
    
    $this->db->from("rugs_tmp ip");
    $this->db->join('cart ct','ct.photo_id=ip.photo_id','left'); 
    $this->db->join('color co','co.id=ip.color','left'); 
    if($page!=-1){
    $this->db->limit($page*$draw,$row);
    }
    $this->db->group_by('ip.photo_id');
    /*$this->db->get();
    echo $this->db->last_query();
     exit;*/
    return $this->db->get();
    
}
public function countProductData($dat,$status){  // ,$photo_id
    $this->db->select("count(ip.id)id_count");
    $this->db->where("ip._vendor",$dat);
    if($status!='all'){
            if($status=='active'){
        $this->db->where("ip.new_arrival!=",2);
            }
            if($status=='inactive'){
        $this->db->where("ip.new_arrival",2);
            }
        }
    
    $this->db->from("rugs_tmp ip");
    $this->db->join('color co','co.id=ip.color','left');
    /*$this->db->get();
    echo $this->db->last_query();
    exit;*/
    return $this->db->get()->row();
    
}

public function getAllProductDataByPhotoId($row,$page,$photo_id,$draw){
    $this->db->select("ip.*,sum(case when ct.qty>0 then ct.qty else 0 end)delivered,co.color");
        $this->db->where("ip.photo_id",$photo_id);
        $this->db->from("rugs_tmp ip");
        $this->db->join('cart ct','ct.photo_id=ip.photo_id','left'); 
        $this->db->join('color co','co.id=ip.color','left'); 
    if($page!=-1){
       $this->db->limit($page*$draw,$row);
    }
    /*$this->db->get();
    echo $this->db->last_query();
     exit;*/
    return $this->db->get();
    
}
public function countProductDataByPhotoId($photo_id){ 
    $this->db->select("count(ip.id)id_count");
    $this->db->where("ip.photo_id",$photo_id);
    $this->db->from("rugs_tmp ip");
    $this->db->join('color co','co.id=ip.color','left');
    /*$this->db->get();
    echo $this->db->last_query();
    exit;*/
    return $this->db->get()->row();
    
}
public function getAllattributes($table,$where){
     $query = $this->db->select("attributes")
              ->from($table)
              ->where($where)
              ->get();
    return $query->result();
    
}


}
