<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        if ($this->session->userdata ('user_logged_in') && company_url($this->session->userdata ('company_slag'))) {
            redirect ( 'dashboard');
        }
        $this->load->model('Login_model');
    }


    public function index(){
        $this->load->view('login');
    }

    function login_check(){
    	$user_name = $this->input->post('user_name');
    	$password = $this->input->post('password');
    	$user_details = $this->Login_model->get_user_details($user_name,$password);
    	if (isset($user_details)) {
    		$user_data = array(
    			'user_name' => $user_details->login_user_name,
                'user_logged_in' => TRUE,
    			'company_slag' => company_url()
    		);
    		$this->session->set_userdata($user_data);
    		redirect ('dashboard');
    	} else {
    		$data['error'] = "Invalid Username/Password";
			$this->load->view('login', $data);
    	}
    }

}
?>