<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        if (! $this->session->userdata ( 'user_logged_in' ) || !company_url($this->session->userdata ('company_slag'))) {
            redirect ( 'login', 'refresh' );
        }
        $this->load->vars ( array (
                'global' => 'Available to all views',
                'header' => 'common/header',
                'left' => 'common/left',
                'footer' => 'common/footer' 
        ) );

        $this->load->model('User_model');
    }

    public function index(){
        $data['user_list'] = $this->User_model->user_list();
        $this->load->view('user_list',$data);
    }

    public function newuser(){
        //$data = array();
        $data['user_id'] = !empty($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $this->load->view('newuser',$data);
    }

    public function user_basic_info(){
        $data = array();
        $data['user_id'] = $this->input->post('user_id');
        $request_from = $this->input->post('request_from');
        if ($data['user_id'] > 0) {
            $data['user_details'] = $this->User_model->get_user_data($data['user_id']);
        }
        if (!empty($request_from) && isset($request_from) && ($request_from == 'ajax')) {
            echo json_encode($data['user_details']);   
        } else {
            $this->load->view('user_basic_info',$data);    
        }
    }

    // public function user_billing_info(){
    //     $this->load->view('user_billing_info');
    // }

    public function save_basic_info(){
        $update_user_id = $this->input->post('user_id');
        $name = $this->input->post('name');
        $company_name = $this->input->post('company_name');
        $contact_display_name = $this->input->post('contact_display_name');
        $contact_email = $this->input->post('contact_email');
        $contact_phone = $this->input->post('contact_phone');
        $contact_website = $this->input->post('contact_website');
        $has_gst = $this->input->post('has_gst');
        $gstn = $this->input->post('gstn');
        $contact_type = $this->input->post('contact_type');
        $billing_address = $this->input->post('billing_address');
        $billing_city = $this->input->post('billing_city');
        $billing_state = $this->input->post('billing_state');
        $billing_zip = $this->input->post('billing_zip');
        $billing_country = $this->input->post('billing_country');
        $billing_fax = $this->input->post('billing_fax');
        $shipping_address = $this->input->post('shipping_address');
        $shipping_city = $this->input->post('shipping_city');
        $shipping_state = $this->input->post('shipping_state');
        $shipping_zip = $this->input->post('shipping_zip');
        $shipping_country = $this->input->post('shipping_country');
        $shipping_fax = $this->input->post('shipping_fax');

        $user_basic_data = array(
                'name' => $name,
                'company_name' => $company_name,
                'contact_display_name' => $contact_display_name,
                'contact_email' => $contact_email,
                'contact_phone' => $contact_phone,
                'contact_website' => $contact_website,
                'has_gst' => $has_gst,
                'gstn' => $gstn,
                'contact_type' => $contact_type,
                'date_added' => date('Y-m-d'),
                'date_updates' => date('Y-m-d'),
                'status' => 1
            );
        if ($update_user_id == 0) {
            $user_id = $this->User_model->insert_data('contact_user',$user_basic_data);
        } else{
            $user_id = $update_user_id;
            $where = array('id'=>$user_id);
            $this->User_model->update_data('contact_user',$user_basic_data,$where);
        }
        
        $user_billing_info = array(
                'id_contact_user'   => $user_id,
                'billing_address'   => $billing_address,
                'billing_city'      => $billing_city,
                'billing_state'     => $billing_state,
                'billing_zip'       => $billing_zip,
                'billing_country'   => $billing_country,
                'billing_fax'       => $billing_fax,
                'billing_date_added'=> date('Y-m-d'),
                'billing_date_update'=> date('Y-m-d')
            );
        if ($update_user_id == 0) {
            $this->User_model->insert_data('contact_user_billing',$user_billing_info);
        } else{
            $where = array('id_contact_user'=>$user_id);
            $this->User_model->update_data('contact_user_billing',$user_billing_info,$where);
        }
        
        $user_shipping_info = array(
                'id_contact_user'   => $user_id,
                'shipping_address'  => $shipping_address,
                'shipping_city'     => $shipping_city,
                'shipping_state'    => $shipping_state,
                'shipping_zip'      => $shipping_zip,
                'shipping_country'  => $shipping_country,
                'shipping_fax'      => $shipping_fax,
                'shipping_date_added'=> date('Y-m-d'),
                'shipping_date_update'=> date('Y-m-d')
            );
        if ($update_user_id == 0) {
            $this->User_model->insert_data('contact_user_shipping',$user_shipping_info);
        } else{
            $where = array('id_contact_user'=>$user_id);
            $this->User_model->update_data('contact_user_shipping',$user_shipping_info,$where);
        }
        echo $user_id;
        
    }

    // public function user_modify($id){
    //     $data['user_details'] = $this->User_model->get_user_data($id);
    //     $this->load->view('user_billing_info',$data);
    // }


}
?>