<?php
$this->load->view ( $left );
$this->load->view ( $header );
?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-4">
        <h2>Invoice Details Report</h2>
    </div>
    <!-- <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php //echo site_url("bank/newbank");?>" class="btn btn-primary">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">Add Bank</span>
            </a>
        </div>
    </div> -->
</div>
<div class="wrapper wrapper-content">
<?php $state_array = array('-','Jammu & Kashmir','Himachal Pradesh','Punjab','Chandigarh','Uttarakhand','Haryana','Delhi','Rajasthan','Uttar Pradesh','Bihar','Sikkim','Arunachal Pradesh','Nagaland','Manipur','Mizoram','Tripura','Meghalaya','Assam','West Bengal','Jharkhand','Odisha','Chhattisgarh','Madhya Pradesh','Gujarat','Daman & Diu','Dadra & Nagar Haveli','Maharashtra','Karnataka','Goa','Lakshdweep','Kerala','Tamil Nadu','Pondicherry','Andaman & Nicobar Islands','Telengana','Andhra Pradesh','Other Territory');?>
    <div class="row text-center animated fadeInRightBig">
        <div class="ibox float-e-margins">
            <div class="ibox-content" style="padding: 15px 20px 15px 20px;">
                <div class="row">
                    <div class="col-lg-4">
                        <label class="col-lg-4 m-t-xs">From</label>
                        <div class="date_calender col-lg-8">
                            <div class="input-group date">
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                <input type="text" name="start_date" id="start_date" class="form-control" value="<?php echo (!empty($start_date) ? date('d/m/Y',strtotime(str_replace('-', '/', $start_date))) : date('d/m/Y'));?>">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <label class="col-lg-4 m-t-xs">To</label>
                        <div class="date_calender col-lg-8">
                            <div class="input-group date">
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                <input type="text" name="end_date" id="end_date" class="form-control" value="<?php echo (!empty($end_date) ? date('d/m/Y',strtotime(str_replace('-', '/', $end_date))) : date('d/m/Y'));?>">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2"><button type="button" class="btn btn-info generate_report"><i class="fa fa-search"></i> Search</button></div>
                    <div class="col-lg-2"><button type="button" class="btn btn-info generate_excel"><i class="fa fa-file-excel-o"></i> Export Excel</button></div>
                </div>
            </div>
        </div>
        <div class="ibox float-e-margins">
            <div class="ibox-content" style="padding: 15px 20px 15px 20px;">
                <div class="row">
                    <table class="table" id="myTable">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Invoice#</th>
                            <th>Order No.</th>
                            <th>Customer</th>
                            <th>Status</th>
                            <th>Due Date</th>
                            <th>Amount</th>
                            <th>Balance Due</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        if (count($report) > 0) {
                            $total_amount = 0;
                            $total_due_amount = 0;
                            foreach ($report as $key_invoice => $value_invoice) {
                                if ($value_invoice->status == 1) {
                                    if (strtotime($value_invoice->due_date) < strtotime(date('Y-m-d'))) {
                                        if (($value_invoice->total - $value_invoice->payment) == 0) {
                                            $status = "<span class='label label-success-light'>Paid</span>";
                                        }else{
                                            $status = "<span class='label label-danger-light'>Over Due</span>";
                                        }
                                    } else {
                                        if (($value_invoice->total - $value_invoice->payment) == 0) {
                                            $status = "<span class='label label-success-light'>Paid</span>";
                                        }else{
                                            $status = "<span class='label label-warning-light'>Due</span>";
                                        }
                                    }
                                } else {
                                    $status = "<span class='label label-success-light'>Draft</span>";
                                }
                                ?>
                                <tr class="invoice_edit" data-invoice_id="<?php echo !empty($value_invoice->invoice_no) ? $value_invoice->invoice_no : '';?>">
                                   <td><?php echo !empty($value_invoice->invoice_date) ? date('d/m/Y',strtotime(str_replace('-', '/', $value_invoice->invoice_date))) : '';?></td>
                                   <td><?php echo !empty($value_invoice->invoice_no) ? $value_invoice->invoice_no : '';?></td>
                                   <td><?php echo !empty($value_invoice->order_no) ? $value_invoice->order_no  : '';?></td>
                                   <td><?php echo !empty($value_invoice->name) ? $value_invoice->name : '';?></td>
                                   <td><?php echo $status;?></td>
                                   <td><?php echo !empty($value_invoice->due_date ) ? date('d/m/Y',strtotime(str_replace('-', '/', $value_invoice->due_date))) : '';?></td>
                                   <td><?php echo !empty($value_invoice->total ) ? number_format((float)$value_invoice->total, 2, '.', '') : '';?></td>
                                   <td><?php echo !empty($value_invoice->total ) ? number_format((float)($value_invoice->total - $value_invoice->payment), 2, '.', '') : '';?></td>
                                </tr>
                        <?php 
                                $total_amount += $value_invoice->total;
                                $total_due_amount += ($value_invoice->total - $value_invoice->payment);
                        }?>
                                <tr style="font-weight: bold;">
                                    <td>Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?php echo number_format((float)$total_amount, 2, '.', '');?></td>
                                    <td><?php echo number_format((float)$total_due_amount, 2, '.', '');?></td>
                                </tr>
                        <?php }?>
                    </tbody>
                </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript">
    $(document).ready(function(){
        var state = <?php echo json_encode($state_array);?>;
        $('#myTable').DataTable();

        $('.date_calender .input-group.date').datepicker({
            todayBtn: "linked",
            keyboardNavigation: false,
            forceParse: false,
            calendarWeeks: true,
            language: 'en',
            autoclose: true
        });

        $('.generate_report').on('click',function(){ 
            var from = chage_date_format($('#start_date').val());
            var to = chage_date_format($('#end_date').val());
            // var customer = $('#choose_customer').val();
            window.location.href = '<?php echo site_url("reports/invoice_details/'+from+'/'+to+'");?>';
            // $.ajax({
            //     url: '<?php //echo site_url('reports/customer_sale');?>',
            //     type: "POST",
            //     data:{
            //         'from'          : from,
            //         'to'            : to,
            //         'customer'      : customer,
            //         'data'          :'json'
            //     },
            //     success: function(response){ 
            //         var data = JSON.parse(response);
            //         var tr = '';
            //         if (data.length > 0) {
            //             data.map(function(value,index){
            //                 var status ='';
            //                 if (value.status_text == 'Paid') {
            //                     status ="<span class='label label-success-light'>Paid</span>";
            //                 }
            //                 if (value.status_text == 'Over Due') {
            //                     status ="<span class='label label-danger-light'>Over Due</span>";
            //                 }
            //                 if (value.status_text == 'Due') {
            //                     status ="<span class='label label-warning-light'>Due</span>";
            //                 }
            //                 if (value.status_text == 'Draft') {
            //                     status ="<span class='label label-success-light'>Draft</span>";
            //                 }
                                
            //                 tr += '<tr class="" data-invoice_id="'+value.invoice_no+'">';
            //                 tr += '<td>'+value.invoice_date+'</td>';
            //                 tr += '<td>'+value.invoice_no+'</td>';
            //                 tr += '<td>'+value.order_no+'</td>';
            //                 tr += '<td>'+value.name+'</td>';
            //                 tr += '<td>'+status+'</td>';
            //                 tr += '<td>'+value.due_date+'</td>';
            //                 tr += '<td>'+value.total+'</td>';
            //                 tr += '<td>'+(parseFloat(value.total) - parseFloat(value.payment))+'</td>';
            //                 tr += '</tr>';
            //             });
            //         }
                    
                    $('#data_report').html('');
                    $('#data_report').html(tr);
            //     }
            // });
        });

        $('.generate_excel').on('click',function(){
            var from = chage_date_format($('#start_date').val());
            var to = chage_date_format($('#end_date').val());
            $.ajax({
                    url: '<?php echo site_url("reports/invoice_details/'+from+'/'+to+'");?>',
                    type: "GET",
                    data:{
                        'data' :'json',
                        'excel' :'1'
                    },
                    success: function(response){ 
                        var data = JSON.parse(response);
                        JSONToCSVConvertor(data, "Invoice Report", true);
                    }
                });
        });

        function JSONToCSVConvertor(JSONData, ReportTitle, ShowLabel) {
            //If JSONData is not an object then JSON.parse will parse the JSON string in an Object
            var arrData = typeof JSONData != 'object' ? JSON.parse(JSONData) : JSONData;
            var CSV = '';    
            //Set Report title in first row or line
            //CSV += ReportTitle + '\r\n\n';
            //This condition will generate the Label/Header
            if (ShowLabel) {
                var row = "";
                //This loop will extract the label from 1st index of on array
                for (var index in arrData[0]) {
                    //Now convert each value to string and comma-seprated
                    row += index + ',';
                }
                row = row.slice(0, -1);
                //append Label row with line break
                CSV += row + '\r\n';
            }
            //1st loop is to extract each row
            for (var i = 0; i < arrData.length; i++) {
                var row = "";   
                //2nd loop will extract each column and convert it in string comma-seprated
                for (var index in arrData[i]) {
                    row += '"' + arrData[i][index] + '",';
                }
                row.slice(0, row.length - 1);
                //add a line break after each row
                CSV += row + '\r\n';
            }
            if (CSV == '') {        
                alert("Invalid data");
                return;
            }   
            //Generate a file name
            var fileName = "";
            //this will remove the blank-spaces from the title and replace it with an underscore
            fileName += ReportTitle.replace(/ /g,"_");   
            //Initialize file format you want csv or xls
            var uri = 'data:text/csv;charset=utf-8,' + escape(CSV);
            // Now the little tricky part.
            // you can use either>> window.open(uri);
            // but this will not work in some browsers
            // or you will not get the correct file extension    
            
            //this trick will generate a temp <a /> tag
            var link = document.createElement("a");    
            link.href = uri;
            
            //set the visibility hidden so it will not effect on your web-layout
            link.style = "visibility:hidden";
            link.download = fileName + ".csv";
            
            //this part will append the anchor tag and remove it after automatic click
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        function chage_date_format(date_str){
            return date_str.replace('/','-').replace('/','-');
        }
    });
</script>