<?php
$this->load->view($left);
$this->load->view($header);
?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-4">
        <h2>Category List</h2>
    </div>
    <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php echo site_url("category/newcategory"); ?>" class="btn btn-primary">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">Add Category</span>
            </a>
        </div>
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <table class="table" id="myTable">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Name</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($category_list) > 0) {
                    foreach ($category_list as $key_bank => $value_bank) {
                        ?>
                        <tr>
                            <td><?php echo!empty($value_bank->id) ? $value_bank->id : ''; ?></td>
                            <td><?php echo!empty($value_bank->name) ? $value_bank->name : ''; ?></td>
                            <td>
                                 <a href="#" onclick="editColor('<?= $value_bank->id ?>')"><button class="btn btn-info btn-xs"><i class="fa fa-edit"></i></button></a>
                                <a href="#" onclick="deleteColor('<?= $value_bank->id ?>');"><button class="btn btn-danger btn-xs"><i class="fa fa-trash"></i></button></a>
                            </td>
                        </tr>
                    <?php }
                }
                ?>
            </tbody>
        </table>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript" language="javascript" src="//code.jquery.com/jquery-1.12.4.js"></script>
<script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script src="//cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script> 	
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script> 
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script> 
<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

<script type="text/javascript">
    var jq = jQuery.noConflict();

    jq(document).ready(function () {
        jq('#myTable').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    });

    function editColor(id) {
        $('#token').val(id);
        $('#frm').attr('action', '<?= base_url() ?>category/newcategory');
        $('#frm').submit();
    }
    function deleteColor(id) {
        $('#token').val(id);
        $('#frm').attr('action', '<?= base_url() ?>category/delcategory');
        $('#frm').submit();

    }
</script>	
<form id="frm" method="post">
    <input type="hidden" id="token" name="token">
</form>