<?php
$this->load->view ( $left );
$this->load->view ( $header );
?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-4">
        <h2>Bank List</h2>
    </div>
    <div class="col-sm-8">
        <div class="title-action">
            <a href="<?php echo site_url("bank/newbank");?>" class="btn btn-primary">
                <i class="fa fa-plus-square-o"></i>
                <span class="m-l-xs">Add Bank</span>
            </a>
        </div>
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <table class="table" id="myTable">
        	<thead>
        		<tr>
        			<th>Account Name</th>
        			<th>Code</th>
                    <th>Bank Name</th>
                    <th>Account Number</th>
                    <th>Routing No.</th>
                    <th>Primary</th>
                    <th>Credit</th>
                    <th>Debit</th>
        			<th>Action</th>
        		</tr>
        	</thead>
            <tbody>
                <?php if (count($bank_list) > 0) {
                    foreach ($bank_list as $key_bank => $value_bank) {?>
                        <tr>
                            <td><?php echo !empty($value_bank->account_name) ? $value_bank->account_name : '';?></td>
                            <td><?php echo !empty($value_bank->account_code) ? $value_bank->account_code : '';?></td>
                            <td><?php echo !empty($value_bank->bank_name) ? $value_bank->bank_name  : '';?></td>
                            <td><?php echo !empty($value_bank->account_number ) ? $value_bank->account_number : '';?></td>
                            <td><?php echo !empty($value_bank->routing_number ) ? $value_bank->routing_number : '';?></td>
                            <td><?php echo ($value_bank->is_primary == 0) ? 'Non-Primary' : 'Primary';?></td>
                            <td>
                                <?php 
                                $credit = 0;
                                if (!empty($value_bank->credit )) {
                                    $credit += $value_bank->credit + $value_bank->credit_bank_charges;
                                }
                                if (isset($bank_deposit_list[$value_bank->account_id])) {
                                    $credit += $bank_deposit_list[$value_bank->account_id]['credit'];
                                }
                                echo number_format((float)$credit, 2, '.', '');?>
                            </td>
                            <td>
                                <?php 
                                $debit = 0;
                                if (!empty($value_bank->debit )) {
                                    $debit += $value_bank->debit;
                                }
                                if (isset($bank_deposit_list[$value_bank->account_id])) {
                                    $debit += $bank_deposit_list[$value_bank->account_id]['debit'];
                                }
                                echo number_format((float)$debit, 2, '.', '');?>
                            </td>
                            <td>
                                <a href="<?php echo site_url('bank/deposit/'.$value_bank->account_id);?>"><button class="btn btn-primary btn-xs"><i class="fa fa-money"></i></button></a>
                                <a href="<?php echo site_url('bank/newbank/'.$value_bank->account_id);?>"><button class="btn btn-info btn-xs"><i class="fa fa-edit"></i></button></a>
                            </td>
                        </tr>
                <?php }
                }?>
            </tbody>
        </table>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript" language="javascript" src="//code.jquery.com/jquery-1.12.4.js"></script>
    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script> 	
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script> 
	<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
	<script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script> 
    <script src="//cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

<script type="text/javascript">
	var jq = jQuery.noConflict();

	jq(document).ready(function() {
	jq('#myTable').DataTable( {
			dom: 'Bfrtip',
			buttons: [
				'copy', 'csv', 'excel', 'pdf', 'print'
			]
		} );
	} );

</script>	