<?php
$this->load->view ( $left );
$this->load->view ( $header );
?>
<style type="text/css">
    .ibox-content {
        border-style : none;
    }

    .hr-line-dashed {
        margin: 5px 0;
    }
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-4">
        <h2><?php echo ($expence_id == 0) ? 'New Expence' : 'Edit Expence';?></h2>
    </div>
</div>
<div class="wrapper wrapper-content">
    <div class="row text-center animated fadeInRightBig">
        <div class="col-lg-12">
            <form method="post" class="form-horizontal" id="expence_data">
                <div class="ibox float-e-margins">
                    <div class="ibox-content">
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Expence Account</label>
                            <div class="col-sm-10">
                                <select name="" class="form-control" name="expence_acc_id" id="expence_acc_id">
                                    <option>Selcet Expence Type</option>
                                    <?php if (count($expence_acount_list) > 0) {
                                        foreach ($expence_acount_list as $key => $value) {?>
                                            <option value="<?php echo $value->expence_acc_id;?>" <?php echo (isset($expence_data[0]->expence_acc_id) && ($value->expence_acc_id == $expence_data[0]->expence_acc_id)) ? 'selected="selected"' : ''; ?>><?php echo $value->expence_acc_name;?></option>
                                        <?php }
                                    }?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Bank Account</label>
                            <div class="col-sm-10">
                                <select name="" class="form-control" name="paid_through_acc" id="paid_through_acc">
                                    <option>Selcet Bank Account</option>
                                    <?php if (count($bank_list) > 0) {
                                        foreach ($bank_list as $key => $value) {?>
                                            <option value="<?php echo $value->account_id;?>" <?php echo (isset($expence_data[0]->paid_through_acc) && ($value->account_id == $expence_data[0]->paid_through_acc)) ? 'selected="selected"' : ''; ?>><?php echo $value->account_name;?></option>
                                        <?php }
                                    }?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">HSN Code</label>
                            <div class="col-sm-10">
                                <input type="text" name="hsn_code" id="hsn_code" class="form-control" placeholder="Account Code" value="<?php echo !empty($expence_data[0]->hsn_code) ? $expence_data[0]->hsn_code : '';?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Amount</label>
                            <div class="col-sm-10">
                                <input type="number" name="amount" id="amount" class="form-control total_tax_alculate" placeholder="Amount" value="<?php echo !empty($expence_data[0]->amount) ? $expence_data[0]->amount : '0';?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">GST Rate%</label>
                            <div class="col-sm-10">
                                <input type="number" name="gst_rate" id="gst_rate" class="form-control total_tax_alculate" placeholder="Gst Rate%" value="<?php echo !empty($expence_data[0]->gst_rate) ? $expence_data[0]->gst_rate : '0';?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Tax Amount</label>
                            <div class="col-sm-1">
                                <lable id="tax" ><strong><?php echo !empty($expence_data[0]->tax_amount) ? $expence_data[0]->tax_amount : '0';?></strong></lable>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">Elegible For Income Tax</label>
                            <div class="col-sm-2">
                                <select name="eligible_for_itc" id="eligible_for_itc" class="form-control">
                                    <option value="1" <?php echo (!empty($expence_data[0]->eligible_for_itc) && ($expence_data[0]->eligible_for_itc == 1)) ? "selected='selected'" : "";?>>Yes</option>
                                    <option value="0" <?php echo (isset($expence_data[0]->eligible_for_itc) && ($expence_data[0]->eligible_for_itc == 0)) ? "selected='selected'" : "";?>>No</option>
                                </select>
                                <!-- <input type="checkbox" name="eligible_for_itc" class="i-checks" id="eligible_for_itc" value="1" <?php //echo !empty($expence_data[0]->eligible_for_itc) ? "checked" : "";?>> -->
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Customar</label>
                            <div class="col-sm-10">
                                <input type="text" name="vendor_customer_name" id="vendor_customer_name" class="form-control" placeholder="Customer / Vendor" value="<?php echo !empty($expence_data[0]->vendor_customer_name) ? $expence_data[0]->vendor_customer_name : '';?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Invoice/Bill </label>
                            <div class="col-sm-10">
                                <input type="text" name="invoice_bill_id" id="invoice_bill_id" class="form-control" placeholder="Invoice / Bill Number" value="<?php echo !empty($expence_data[0]->invoice_bill_id) ? $expence_data[0]->invoice_bill_id : '';?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Expance Date </label>
                            <div class="date_calender col-sm-10">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                    <input type="text" name="expence_date" id="expence_date" class="form-control" value="<?php echo (!empty($expence_data[0]->expence_date) ? date('d/m/Y',strtotime(str_replace('-', '/', $expence_data[0]->expence_date))) : date('d/m/Y'));?>">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Description</label>
                            <div class="col-sm-10">
                                <input type="text" name="note" id="note" class="form-control" placeholder="Note" value="<?php echo !empty($expence_data[0]->note) ? $expence_data[0]->note : '';?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ibox">
                    <div class="ibox-content">
                        <div class="row">
                            <div class="col-lg-6 pull-right">
                                <div class="form-group">
                                    <div class="col-sm-12 col-sm-offset-2">
                                        <button class="btn btn-primary save_expence_details" type="button" data-status="1"><i class="fa "></i><span class="m-l-xs">Save</span></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $this->load->view($footer); ?>
<script type="text/javascript">
    $(document).ready(function(){
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
        var tax_amount = 0;
        $('.total_tax_alculate').on('keyup',function(){
            var amount = parseFloat($('#amount').val());
            var gst = parseFloat($('#gst_rate').val());
            tax_amount = (amount*gst)/100;
            $('#tax').html('').html('<strong>'+tax_amount+'</strong>');

        });

        $('.date_calender .input-group.date').datepicker({
            todayBtn: "linked",
            keyboardNavigation: false,
            forceParse: false,
            calendarWeeks: true,
            language: 'en',
            autoclose: true
        });

        $('.save_expence_details').on('click',function(){
            if ($('#expence_date').val() == '') {
                $('#expence_date').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#expence_date').parent().parent().removeClass('has-error');
            }
            
            if ($('#expence_acc_id').val() == '') {
                $('#expence_acc_id').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#expence_acc_id').parent().parent().removeClass('has-error');
            }

            if ($('#paid_through_acc').val() == '') {
                $('#paid_through_acc').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#paid_through_acc').parent().parent().removeClass('has-error');
            }

            if ($('#hsn_code').val() == '') {
                $('#hsn_code').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#hsn_code').parent().parent().removeClass('has-error');
            }

            if ($('#amount').val() == '') {
                $('#amount').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#amount').parent().parent().removeClass('has-error');
            }

            if ($('#gst_rate').val() == '') {
                $('#gst_rate').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#gst_rate').parent().parent().removeClass('has-error');
            }

            if ($('#vendor_customer_name').val() == '') {
                $('#vendor_customer_name').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#vendor_customer_name').parent().parent().removeClass('has-error');
            }

            if ($('#invoice_bill_id').val() == '') {
                $('#invoice_bill_id').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#invoice_bill_id').parent().parent().removeClass('has-error');
            }

            if ($('#note').val() == '') {
                $('#note').parent().parent().addClass('has-error');
                return false;
            } else {
                $('#note').parent().parent().removeClass('has-error');
            }

            var expence_id         = '<?php echo $expence_id; ?>';
            var expence_acc_id    = $('#expence_acc_id').val();
            var paid_through_acc    = $('#paid_through_acc').val();
            var hsn_code  = $('#hsn_code').val();
            var amount       = $('#amount').val();
            var gst_rate  = $('#gst_rate').val();
            var vendor_customer_name  = $('#vendor_customer_name').val();
            var invoice_bill_id  = $('#invoice_bill_id').val();
            var note     = $('#note').val();
            var eligible_for_itc  = $('#eligible_for_itc').val();
            var expence_date  = $('#expence_date').val();
            
            $.ajax({
                url: '<?php echo site_url('expence/save_expence');?>',
                type: "POST",
                data:{
                    'expence_date'          : expence_date,
                    'expence_id'            : expence_id,
                    'expence_acc_id'        : expence_acc_id,
                    'paid_through_acc'      : paid_through_acc,
                    'hsn_code'              : hsn_code,
                    'amount'                : amount,
                    'gst_rate'              : gst_rate,
                    'tax_amount'            : tax_amount,
                    'vendor_customer_name'  : vendor_customer_name,
                    'invoice_bill_id'       : invoice_bill_id,
                    'note'                  : note,
                    'eligible_for_itc'      : eligible_for_itc
                },
                success: function(data){ 
                    window.location.href = '<?php echo site_url("expence/list_expences");?>';
                }
            });
        });
    });
</script>
