<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('css_url'))
{
	function css_url($nom)
	{
		return CDN_SITE_URL . 'assets/css/' . $nom . '.css';
	}
}

if ( ! function_exists('company_url'))
{
    function company_url($slug='')
    {
        if($slug==''){
            $url_arr = explode('/', $_SERVER['REQUEST_URI']);
            return $url_arr[1];
        } else {
            $url_arr = explode('/', $_SERVER['REQUEST_URI']);
            return (($url_arr[1] == $slug) ? TRUE : FALSE);
        }
        
    }
}

if ( ! function_exists('js_url'))
{
	function js_url($nom)
	{
		return CDN_SITE_URL . 'assets/js/' . $nom . '.js';
	}
}

if ( ! function_exists('img_url'))
{
    function img_url($nom)
    {
        return CDN_SITE_URL . 'assets/img/' . $nom;
    }
}
if ( ! function_exists('barcode_url'))
{
	function barcode_url($nom)
	{
		return CDN_SITE_URL . 'assets/barcodeImg/' . $nom;
	}
}

if ( ! function_exists('logo_url'))
{
	function logo_url($nom)
	{
		return CDN_SITE_URL . 'assets/img/logos/' . $nom . '.jpg';
	}
}

if ( ! function_exists('visuel_url'))
{
	function visuel_url($nom)
	{
		return CDN_SITE_URL . 'assets/img/visuels/' . $nom . '.jpg';
	}
}

if ( ! function_exists('plugin_url'))
{
	function plugin_url($nom)
	{
		return CDN_SITE_URL . 'assets/plugins/' . $nom;
	}
}
if ( ! function_exists('reg_string')) {
	function reg_string ($string) {
		$result = preg_replace('([{}\(\)\^$&._%#!@=<>:;,~`\�"\'\*\?\/\+\|\[\\\\]|\]|\-)', '', $string);
		$result = removeAccents($result);
		$result = strtolower($result);
		return str_replace(" ", "_", $result);
	}
	function removeAccents($str) {
		$a = array('�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', '�', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', '�', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', '?', '?', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', '?', '?', 'L', 'l', 'N', 'n', 'N', 'n', 'N', 'n', '?', 'O', 'o', 'O', 'o', 'O', 'o', '�', '�', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', '�', '�', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', '�', 'Z', 'z', 'Z', 'z', '�', '�', '?', '�', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', '?', '?', '?', '?', '?', '?');
	  	$b = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
	  	return str_replace($a, $b, $str);
	}
}

if ( ! function_exists('get_time'))
{
    function get_time($now){
        if($now < 60){
            return 'il y a '.$now.' seconde(s) à ';
        }
        else if($now >=60 && $now < 3600){
            $minute = intval($now/60);
            $sec = $now - (60 * $minute);
            return 'il y a '.$minute.' minute(s) et '.$sec.' seconde(s) à ';
        }
        else if($now >=3600 && $now<86400){
            $hour = intval($now/3600);
            $sec = $now - (3600 * $hour);
            if($sec >=60 && $sec < 3600 ){
                $minute = intval($sec/60);
                $second = $sec - (60 * $minute);
                return 'il y a '.$hour.' heure(s) et '.$minute.' minute(s) à ';
            }
        }
        else if($now >= 86400 ){///&& $now < (3*86400)
            $day = intval($now/86400);
            $sec = $now - (86400 * $day);
            if($sec >= 3600 && $sec < 86400){
                $hour = intval($sec/3600);
                $second =  $sec - (3600 * $hour);
            }
            else if(@$second >=60 && @$second < 3600 ){
                $minute = intval($second/60);
                $seconds = $second - (60 * $minute);
            }
            else if(@$seconds < 60){
                $sec = $now;
            }
            return 'il y a '.$day.' jour(s) à ';
        }
        else if($now >= (3*86400)){
            $time = date("Y-m-d H:i:s",time()-$now);
            $date = date('d/m/Y', strtotime($time));
            $t = date('H:i', strtotime($time));
            
            return ' à ';
           // return $date.' '.$mont.' '.$year;
        }
    }
}