<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Design extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
         if (! $this->session->userdata ( 'user_logged_in' ) || !company_url($this->session->userdata ('company_slag'))) {
            redirect ( 'login', 'refresh' );
        }
        $this->load->vars ( array (
                'global' => 'Available to all views',
                'header' => 'common/header',
                'left' => 'common/left',
                'footer' => 'common/footer' 
        ) );
        $this->load->model('Design_model');
        
    }
    
    public function index(){
          $data['list'] = $this->Design_model->AllRecordWithWhere('design',array('status'=>1));			
        
       //echo "<pre>";
        //print_r($data);
        //exit();		
		
        $this->load->view('master/design_list',$data);
    }

    
    public function new(){
        $data=array();
        $token=$this->input->post('token');
        if($token!=''){
            $data['design_row']=$this->Design_model->GetARecordWithWhereRowDESC("design",array('id'=>$token));
        }
        $this->load->view('master/new_design',$data);
    }



    public function add_design(){
        $data=$this->input->post();      
        if($data['id']!=''){
             $rest=$this->Design_model->Edit("design",$data,'id',$data['id']);
            echo $rest;
            exit;
            
        }else{
            unset($data['id']);
            $rest=$this->Design_model->Add("design",$data);
            echo $rest;
            exit;
            
        }
    }
    public function del_design(){
        $token=$this->input->post('token');
        if(!empty($token)){
            $rest=$this->Design_model->DelWhere('design',array('id'=>$token));            
        }
        redirect(base_url().'design');
    }


    public function getDesignerByText(){
        //$keyword = $_GET[];
        $keyword = $_GET['keyword']['term']; //exit;
        //$data['designer'] = $this->Design_model->AllRecord("designers", array('id', 'firstname', 'lastname'))->result();

        $this->db->select('concat(firstname, lastname) as text, concat(id,"_",concat(firstname,lastname)) as id');
        $this->db->from('designers');
        if(!empty($keyword)) {
            $this->db->group_start();
            $this->db->like('firstname', $keyword);
            $this->db->or_like('lastname', $keyword);
            $this->db->group_end();
        }
        //$this->db->like('firstname', $keyword);
        $query = $this->db->get();

        echo json_encode($query->result_array());exit;
    }
}